/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.cloud.msc.ist;

import com.iflytek.cloud.a.i.m.a;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class AudioAccessor {
    private static final int MAX_BUF_LEN = 0x500000;
    private static final int MIN_OUTPUT_TIME = 3000;
    private String mFilePath;
    private AccesserType mAccesserType;
    private int mOffset;
    private ByteBuffer mByteBuffer;
    private byte[] mBuffer;
    private int mBufLen;
    private int mDataCount;
    private long mLastFlushTime;
    private File mAudioFile;
    private RandomAccessFile mAccessFile;
    private FileChannel mFileChannel;
    private Object mFileSyncObj;
    private final String FILE_FMT;
    private final int SIZE_OF_WAVE_HEADER;
    private final int DATA_LENGTH_OFFSET;
    private final int FILE_LENGTH_OFFSET;
    private short mNumChannels;
    private short mFormat;
    private short mBitsPerSample;
    private int mSampleRate;

    public static AudioAccessor createBufferAccessor() throws IOException {
        return new AudioAccessor();
    }

    public static AudioAccessor createReadOnlyAccessor(String string) throws IOException {
        return new AudioAccessor(string);
    }

    public static AudioAccessor createWriteReadAccessor(String string, int n) throws IOException {
        return new AudioAccessor(string, n);
    }

    protected AudioAccessor() throws IOException {
        this.mFilePath = null;
        this.mAccesserType = AccesserType.WRITE_READ;
        this.mOffset = 0;
        this.mByteBuffer = ByteBuffer.allocate(0x500000);
        this.mBuffer = new byte[0x500000];
        this.mBufLen = 0;
        this.mDataCount = 0;
        this.mLastFlushTime = System.currentTimeMillis();
        this.mAudioFile = null;
        this.mAccessFile = null;
        this.mFileChannel = null;
        this.mFileSyncObj = new Object();
        this.FILE_FMT = ".wav";
        this.SIZE_OF_WAVE_HEADER = 44;
        this.DATA_LENGTH_OFFSET = 40;
        this.FILE_LENGTH_OFFSET = 4;
        this.mNumChannels = 1;
        this.mFormat = 1;
        this.mBitsPerSample = (short)16;
        this.mSampleRate = 16000;
        this.mAccesserType = AccesserType.BUFFER;
    }

    protected AudioAccessor(String string) throws IOException {
        this.mFilePath = null;
        this.mAccesserType = AccesserType.WRITE_READ;
        this.mOffset = 0;
        this.mByteBuffer = ByteBuffer.allocate(0x500000);
        this.mBuffer = new byte[0x500000];
        this.mBufLen = 0;
        this.mDataCount = 0;
        this.mLastFlushTime = System.currentTimeMillis();
        this.mAudioFile = null;
        this.mAccessFile = null;
        this.mFileChannel = null;
        this.mFileSyncObj = new Object();
        this.FILE_FMT = ".wav";
        this.SIZE_OF_WAVE_HEADER = 44;
        this.DATA_LENGTH_OFFSET = 40;
        this.FILE_LENGTH_OFFSET = 4;
        this.mNumChannels = 1;
        this.mFormat = 1;
        this.mBitsPerSample = (short)16;
        this.mSampleRate = 16000;
        this.mFilePath = string;
        this.mAccesserType = AccesserType.READ_ONLY;
        this.initFile();
    }

    protected AudioAccessor(String string, int n) throws IOException {
        AudioAccessor audioAccessor = object;
        AudioAccessor audioAccessor2 = object;
        object.mFilePath = null;
        Object object = AccesserType.WRITE_READ;
        v2.mAccesserType = object;
        v2.mOffset = 0;
        v2.mByteBuffer = ByteBuffer.allocate(0x500000);
        v2.mBuffer = new byte[0x500000];
        v2.mBufLen = 0;
        v2.mDataCount = 0;
        v2.mLastFlushTime = System.currentTimeMillis();
        v2.mAudioFile = null;
        v2.mAccessFile = null;
        v2.mFileChannel = null;
        v2.mFileSyncObj = new Object();
        v2.FILE_FMT = ".wav";
        v2.SIZE_OF_WAVE_HEADER = 44;
        v2.DATA_LENGTH_OFFSET = 40;
        v2.FILE_LENGTH_OFFSET = 4;
        v2.mNumChannels = 1;
        v2.mFormat = 1;
        v2.mBitsPerSample = (short)16;
        v2.mSampleRate = 16000;
        audioAccessor2.mFilePath = string;
        audioAccessor.mSampleRate = n;
        audioAccessor.mAccesserType = object;
        audioAccessor.initFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void saveAudio() throws IOException {
        block14: {
            v0 = this;
            a.d("saveAudioData enter");
            var1_1 = v0.mFileSyncObj;
            synchronized (var1_1) {
                if (v0.mFileChannel == null) break block14;
                a.d("saveAudio write audio len:" + this.mBufLen + ", file length=" + this.getFileLength());
                if (this.mBufLen <= 0) ** GOTO lbl44
                v1 = this;
                v2 = v1;
                v3 = v1;
                v4 = v1;
                v5 = v1;
                v6 = v1;
                v7 = v1;
                v8 = v1;
                v9 = v1;
                v1.mByteBuffer.clear();
                var2_2 = v7.mByteBuffer.capacity() - this.mBufLen;
                v8.mByteBuffer.position(var2_2);
                v10 = v9.mByteBuffer;
                v11 = this;
                v12 = v11;
                var3_3 = v11.mBuffer;
                var4_5 = 0;
                var5_6 = v12.mBufLen;
                v10.put(var3_3, var4_5, var5_6);
                var3_4 = (int)v5.getFileLength();
                v3.writeBytes(var3_4, v6.mByteBuffer, var2_2);
                v4.mBufLen = 0;
                v2.updateAudioFileHeader();
lbl44:
                // 2 sources

                if (AccesserType.WRITE_READ != this.mAccesserType) break block14;
                if (!this.isTimeToFlush()) break block14;
                a.d("saveAudio flush to device.");
                this.flush();
            }
        }
        a.d("saveAudioData leave");
        return;
        {
            catch (Throwable v13) {
                throw v13;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void initFile() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [31[UNCONDITIONALDOLOOP]], but top level block is 20[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isTimeToFlush() {
        long l2 = System.currentTimeMillis() - this.mLastFlushTime;
        return 3000L <= l2;
    }

    private long getFileLength() throws IOException {
        int n = 0;
        FileChannel fileChannel = this.mFileChannel;
        if (fileChannel != null) {
            n = (int)fileChannel.size();
        }
        a.a("getFileLength:" + n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilePath() {
        AudioAccessor audioAccessor = object;
        Object object = null;
        Object object2 = audioAccessor.mFileSyncObj;
        synchronized (object2) {
            block5: {
                File file = audioAccessor.mAudioFile;
                if (file == null) break block5;
                object = file.getAbsolutePath();
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDataLength() {
        AudioAccessor audioAccessor = object;
        Object object = audioAccessor.mFileSyncObj;
        synchronized (object) {
            long l2 = audioAccessor.mDataCount;
            return l2;
        }
    }

    public String getAudioInfo(AudioKeys audioKeys) {
        String string = null;
        switch (1.$SwitchMap$com$iflytek$cloud$msc$ist$AudioAccessor$AudioKeys[audioKeys.ordinal()]) {
            default: {
                break;
            }
            case 4: {
                string = String.valueOf(this.mSampleRate);
                break;
            }
            case 3: {
                string = String.valueOf(this.mBitsPerSample);
                break;
            }
            case 2: {
                string = String.valueOf(this.mFormat);
                break;
            }
            case 1: {
                string = String.valueOf(this.mNumChannels);
            }
        }
        return string;
    }

    public int getBufferLength() {
        return 0x500000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCacheLeft() {
        Object object = this.mFileSyncObj;
        synchronized (object) {
            int n = 0x280000 - this.mBufLen;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int getAudio(byte[] var1_1) throws IOException {
        block28: {
            block31: {
                block29: {
                    block30: {
                        a.d("getAudioData enter");
                        var2_2 = 0;
                        if (AccesserType.BUFFER != this.mAccesserType) break block29;
                        if (var1_1 == null || var1_1.length != this.getBufferLength()) break block30;
                        v0 = this;
                        var3_3 = v0.mFileSyncObj;
                        synchronized (var3_3) {
                            block25: {
                                var4_5 = v0.mBuffer;
                                if (v0.mBuffer == null) break block25;
                                var5_7 = this.mBufLen;
                                if (var5_7 <= 0) ** GOTO lbl22
                                System.arraycopy(var4_5, 0, var1_1, 0, var5_7);
                                var2_2 = this.mBufLen;
                                this.mBufLen = 0;
                                a.d("getAudioData len:" + var2_2);
lbl22:
                                // 2 sources

                                // MONITOREXIT @DISABLED, blocks:[3, 21] lbl20 : MonitorExitStatement: MONITOREXIT : var3_3
                                var4_6 = var2_2;
                            }
                            throw new IOException("Data array is null!");
                        }
                    }
                    var2_2 = -1;
                    a.b("getAudioData buffer is null or length is error !");
                    var4_6 = var2_2;
                    break block28;
                }
                if (var1_1 == null || var1_1.length != this.getBufferLength()) break block31;
                v2 = this;
                var3_4 = v2.mFileSyncObj;
                synchronized (var3_4) {
                    block27: {
                        block26: {
                            if (v2.mFileChannel == null) ** GOTO lbl95
                            if (this.getFileLength() <= 44L) break block26;
                            v4 = this;
                            v5 = v4;
                            v4.mByteBuffer.clear();
                            v6 = v5.mByteBuffer.capacity();
                            v7 = this.getFileLength() - (long)this.mOffset;
                            var4_6 = (int)Math.min(v6, v7);
                            a.d("getAudioData buffer len:" + var4_6);
                            if (var4_6 <= 0) break block26;
                            v8 = var4_6;
                            v9 = this;
                            v10 = v9;
                            v11 = v9;
                            v12 = v9;
                            v13 = v9.mFileChannel;
                            v14 = this.mOffset;
                            v13.position(v14);
                            var2_2 = v10.mOffset;
                            if (v8 != v12.readBytes(var2_2, v11.mByteBuffer)) ** GOTO lbl89
                            v15 = this;
                            v16 = v15;
                            v17 = v15;
                            v18 = v15;
                            v15.mByteBuffer.position(0);
                            v16.mByteBuffer.get(var1_1, 0, var4_6);
                            v19 = v17.mOffset;
                            v18.mOffset = v19 + var4_6;
                            a.d("getAudioData read len:" + var4_6);
                            break block27;
lbl89:
                            // 1 sources

                            throw new IOException("Read audio length error:" + var4_6);
                        }
                        var4_6 = var2_2;
                    }
                    break block28;
lbl95:
                    // 1 sources

                    throw new IOException("File is null!");
                }
            }
            var4_6 = -1;
            a.b("getAudioData buffer is null or length is not enough !");
        }
        a.d("getAudioData leave");
        return var4_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean putAudio(byte[] byArray, int n) throws IOException {
        a.d("putAudio enter");
        if (byArray != null) {
            Object object = this.mAccesserType;
            if (AccesserType.BUFFER == object && 0x500000 < this.mBufLen + n) {
                a.b("Buffer is not enough ! " + this.mBufLen);
                throw new IOException("Buffer is not enough ! " + this.mBufLen);
            }
            if (AccesserType.READ_ONLY != object) {
                if (byArray != null && n > 0) {
                    object = this.mFileSyncObj;
                    AudioAccessor audioAccessor = this;
                    AudioAccessor audioAccessor2 = this;
                    synchronized (object) {
                        a.d("putAudio data len=" + n);
                        int n2 = 0;
                        byte[] byArray2 = audioAccessor2.mBuffer;
                        int n3 = audioAccessor2.mBufLen;
                        System.arraycopy(byArray, n2, byArray2, n3, n);
                        int n4 = audioAccessor.mBufLen;
                        audioAccessor.mBufLen = n4 + n;
                        int n5 = audioAccessor.mDataCount;
                        audioAccessor.mDataCount = n5 + n;
                        a.d("putAudio buf len=" + this.mBufLen);
                    }
                }
                if (AccesserType.WRITE_READ == this.mAccesserType) {
                    this.saveAudio();
                }
                a.d("putAudio leave");
                return true;
            }
            a.b("Current type is " + (Object)((Object)this.mAccesserType));
            throw new IOException("Current type is " + (Object)((Object)this.mAccesserType));
        }
        a.b("data is null !");
        throw null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() throws IOException {
        if (AccesserType.WRITE_READ == this.mAccesserType) {
            Object object = this.mFileSyncObj;
            synchronized (object) {
                this.mFileChannel.force(true);
                this.mLastFlushTime = System.currentTimeMillis();
                return;
            }
        }
        throw new IOException("Current type is " + (Object)((Object)this.mAccesserType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void close() throws IOException {
        a.a("AudioAccesser close enter");
        var1_1 = this.mFileSyncObj;
        synchronized (var1_1) {
            if (AccesserType.WRITE_READ != this.mAccesserType) ** GOTO lbl10
            this.saveAudio();
lbl10:
            // 2 sources

            if (AccesserType.BUFFER == this.mAccesserType) ** GOTO lbl22
            var2_2 = this.mFileChannel;
            if (var2_2 == null) ** GOTO lbl18
            var2_2.force(true);
            this.mFileChannel.close();
            this.mFileChannel = null;
lbl18:
            // 2 sources

            if ((var2_2 = this.mAccessFile) == null) ** GOTO lbl22
            var2_2.close();
            this.mAccessFile = null;
lbl22:
            // 3 sources

            v1 = var1_1;
            v2 = this;
            v3 = v2;
            v2.mBuffer = null;
            v2.mByteBuffer.clear();
            v3.mByteBuffer = null;
            // ** MonitorExit[v1] (shouldn't be in output)
            a.a("AudioAccesser close leave");
            return;
        }
    }

    protected void initAudioFileHeader() throws IOException {
        AudioAccessor audioAccessor = this;
        audioAccessor.writeBytes(0, "RIFF".getBytes());
        audioAccessor.writeInt(4, 44);
        audioAccessor.writeBytes(8, "WAVE".getBytes());
        audioAccessor.writeBytes(12, "fmt ".getBytes());
        audioAccessor.writeInt(16, 16);
        audioAccessor.writeShort(20, audioAccessor.mFormat);
        audioAccessor.writeShort(22, audioAccessor.mNumChannels);
        audioAccessor.writeInt(24, audioAccessor.mSampleRate);
        short s = audioAccessor.mNumChannels;
        short s2 = this.mBitsPerSample;
        int n = s * this.mSampleRate * s2 / 8;
        s2 = (short)(s * s2 / 8);
        a.d("writeAudioFileHeader NumChannels=" + this.mNumChannels + "SampleRate=" + this.mSampleRate + ", transferRate=" + n + ", adjustValue=" + s2 + ", bit=" + this.mBitsPerSample);
        audioAccessor.writeInt(28, n);
        audioAccessor.writeShort(32, s2);
        audioAccessor.writeShort(34, audioAccessor.mBitsPerSample);
        audioAccessor.writeBytes(36, "data".getBytes());
        audioAccessor.writeInt(40, 0);
    }

    protected void readAudioInfo() throws IOException {
        String string;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        this.readBytes(0, byteBuffer);
        String string2 = string;
        string = new String(byteBuffer.array());
        if (!"RIFF".equalsIgnoreCase(string2)) {
            return;
        }
        AudioAccessor audioAccessor = this;
        audioAccessor.mFormat = audioAccessor.readShort(20);
        audioAccessor.mNumChannels = audioAccessor.readShort(22);
        audioAccessor.mSampleRate = audioAccessor.readInt(24);
        audioAccessor.mBitsPerSample = audioAccessor.readShort(34);
    }

    protected void writeBytes(int n, ByteBuffer byteBuffer) throws IOException {
        AudioAccessor audioAccessor = this;
        a.d("writeBytes buffer len=" + byteBuffer.capacity());
        byteBuffer.rewind();
        audioAccessor.mFileChannel.position(n);
        a.d("writeBytes writen len=" + audioAccessor.mFileChannel.write(byteBuffer));
    }

    protected void writeBytes(int n, ByteBuffer byteBuffer, int n2) throws IOException {
        AudioAccessor audioAccessor = this;
        a.d("writeBytes buffer len=" + (byteBuffer.capacity() - n2));
        byteBuffer.position(n2);
        audioAccessor.mFileChannel.position(n);
        a.d("writeBytes writen len=" + audioAccessor.mFileChannel.write(byteBuffer));
    }

    protected void writeBytes(int n, byte[] byArray) throws IOException {
        AudioAccessor audioAccessor = byteBuffer;
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.put(byArray);
        audioAccessor.writeBytes(n, byteBuffer);
    }

    protected void writeInt(int n, int n2) throws IOException {
        AudioAccessor audioAccessor = byteBuffer;
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put(0, (byte)(n2 >> 0));
        byteBuffer.put(1, (byte)(n2 >> 8));
        byteBuffer.put(2, (byte)(n2 >> 16));
        byteBuffer.put(3, (byte)(n2 >> 24));
        audioAccessor.writeBytes(n, byteBuffer);
    }

    protected void writeShort(int n, short s) throws IOException {
        AudioAccessor audioAccessor = byteBuffer;
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.put(0, (byte)(s >> 0));
        byteBuffer.put(1, (byte)(s >> 8));
        audioAccessor.writeBytes(n, byteBuffer);
    }

    protected int readInt(int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        AudioAccessor audioAccessor = this;
        audioAccessor.mFileChannel.position(n);
        audioAccessor.mFileChannel.read(byteBuffer);
        return byteBuffer.getInt(0) << 0 | byteBuffer.getInt(1) << 8 | byteBuffer.getInt(2) << 16 | byteBuffer.getInt(3) << 24;
    }

    protected int readBytes(int n, ByteBuffer byteBuffer) throws IOException {
        AudioAccessor audioAccessor = this;
        audioAccessor.mFileChannel.position(n);
        return audioAccessor.mFileChannel.read(byteBuffer);
    }

    protected short readShort(int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        AudioAccessor audioAccessor = this;
        audioAccessor.mFileChannel.position(n);
        audioAccessor.mFileChannel.read(byteBuffer);
        return (short)(byteBuffer.getShort(0) << 0 | byteBuffer.getShort(1) << 8);
    }

    protected void updateAudioFileHeader() throws IOException {
        AudioAccessor audioAccessor = this;
        a.d("updateHeader File length:" + this.getDataLength() + ", mem file length:" + this.mFileChannel.size());
        audioAccessor.writeInt(4, (int)audioAccessor.getDataLength());
        a.d("updateHeader data length:" + (this.getDataLength() - 44L));
        audioAccessor.writeInt(40, (int)audioAccessor.getDataLength() - 44);
    }

    public static final class AudioKeys
    extends Enum<AudioKeys> {
        public static final /* enum */ AudioKeys CHANNEL;
        public static final /* enum */ AudioKeys FORMAT;
        public static final /* enum */ AudioKeys BIT;
        public static final /* enum */ AudioKeys RATE;
        private static final /* synthetic */ AudioKeys[] $VALUES;

        public static AudioKeys[] values() {
            return (AudioKeys[])$VALUES.clone();
        }

        public static AudioKeys valueOf(String string) {
            return Enum.valueOf(AudioKeys.class, string);
        }

        static {
            AudioKeys audioKeys;
            AudioKeys audioKeys2;
            AudioKeys audioKeys3;
            AudioKeys audioKeys4;
            AudioKeys audioKeys5 = audioKeys4;
            CHANNEL = new AudioKeys();
            AudioKeys audioKeys6 = audioKeys3;
            FORMAT = new AudioKeys();
            AudioKeys audioKeys7 = audioKeys2;
            BIT = new AudioKeys();
            AudioKeys audioKeys8 = audioKeys;
            RATE = new AudioKeys();
            $VALUES = new AudioKeys[]{audioKeys5, audioKeys6, audioKeys7, audioKeys8};
        }
    }

    static final class AccesserType
    extends Enum<AccesserType> {
        public static final /* enum */ AccesserType WRITE_READ;
        public static final /* enum */ AccesserType READ_ONLY;
        public static final /* enum */ AccesserType BUFFER;
        private static final /* synthetic */ AccesserType[] $VALUES;

        public static AccesserType[] values() {
            return (AccesserType[])$VALUES.clone();
        }

        public static AccesserType valueOf(String string) {
            return Enum.valueOf(AccesserType.class, string);
        }

        static {
            AccesserType accesserType;
            AccesserType accesserType2;
            AccesserType accesserType3;
            AccesserType accesserType4 = accesserType3;
            WRITE_READ = new AccesserType();
            AccesserType accesserType5 = accesserType2;
            READ_ONLY = new AccesserType();
            AccesserType accesserType6 = accesserType;
            BUFFER = new AccesserType();
            $VALUES = new AccesserType[]{accesserType4, accesserType5, accesserType6};
        }
    }
}

