/*
 * Decompiled with CFR 0.152.
 */
package com.pax.neptunelite.api;

import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import com.pax.dal.IDAL;
import com.pax.dal.proxy.IDALProxy;
import com.pax.neptunelite.api.Nepcore;
import dalvik.system.DexClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class NeptuneLiteUser {
    private static NeptuneLiteUser neptuneLiteUser;
    private IDAL dal;
    private static final String DALPROXY_CLASS_NAME = "com.pax.dal.impl.DALProxy";
    private static final String FILE_NAME = "nepcore.dex";
    private DexClassLoader dexClassLoader = null;

    private NeptuneLiteUser() {
    }

    public static synchronized NeptuneLiteUser getInstance() {
        if (neptuneLiteUser == null) {
            neptuneLiteUser = new NeptuneLiteUser();
        }
        return neptuneLiteUser;
    }

    public synchronized IDAL getDal(Context context) throws Exception {
        if (this.dal == null) {
            this.dal = this.loadDalDex(context, FILE_NAME);
        }
        return this.dal;
    }

    public synchronized IDAL getDalWithProcessSafe(Context context) throws Exception {
        if (this.dal == null) {
            String processName = this.getProcessName();
            if (TextUtils.isEmpty((CharSequence)processName)) {
                this.dal = this.loadDalDex(context, FILE_NAME);
            } else {
                String dexFileName = processName.replace(':', '_') + ".dex";
                this.dal = this.loadDalDex(context, dexFileName);
            }
        }
        return this.dal;
    }

    private IDAL loadDalDex(Context context, String dexFileName) throws Exception {
        if (TextUtils.isEmpty((CharSequence)dexFileName)) {
            throw new Exception("LOAD DAL ERR");
        }
        File file = null;
        try {
            file = new File(context.getFilesDir().getAbsolutePath(), dexFileName);
            if (!this.writeNepcoreFile(file)) {
                throw new Exception("LOAD DAL ERR");
            }
            String dexPath = file.getAbsolutePath();
            String optimizedDirectoryPath = context.getDir("dex", 0).getAbsolutePath();
            String libraryPath = context.getApplicationInfo().nativeLibraryDir;
            this.dexClassLoader = new DexClassLoader(dexPath, optimizedDirectoryPath, libraryPath, context.getClassLoader());
            Class glClass = this.dexClassLoader.loadClass(DALPROXY_CLASS_NAME);
            Constructor istructor = glClass.getConstructor(Context.class);
            IDALProxy dalProxy = (IDALProxy)istructor.newInstance(context);
            IDAL iDAL = dalProxy.getDal();
            return iDAL;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("LOAD DAL ERR");
        }
        finally {
            if (null != file && file.exists()) {
                file.delete();
            }
        }
    }

    private String getNepcoreFieldValue(Nepcore nepcore, String fieldName) {
        Field[] fields;
        Class<?> clazz = nepcore.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!fieldName.equals(field.getName())) continue;
            field.setAccessible(true);
            try {
                return (String)field.get(nepcore);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeNepcoreFile(File file) {
        OutputStream out = null;
        try {
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            if (file.exists()) {
                file.delete();
            }
            out = new FileOutputStream(file);
            Nepcore nepcore = new Nepcore();
            for (int i = 0; i < nepcore.count; ++i) {
                String dexData = this.getNepcoreFieldValue(nepcore, "nepcore" + i);
                if (dexData == null) continue;
                byte[] dex = this.strToBcd(dexData);
                ((FileOutputStream)out).write(dex, 0, dex.length);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    byte[] strToBcd(String str) {
        int len = str.length();
        int mod = len % 2;
        if (mod != 0) {
            str = str + "0";
            len = str.length();
        }
        if (len >= 2) {
            len /= 2;
        }
        byte[] bbt = new byte[len];
        byte[] abt = str.getBytes();
        for (int p = 0; p < str.length() / 2; ++p) {
            byte b;
            int j = abt[2 * p] >= 97 && abt[2 * p] <= 122 ? abt[2 * p] - 97 + 10 : (abt[2 * p] >= 65 && abt[2 * p] <= 90 ? abt[2 * p] - 65 + 10 : abt[2 * p] - 48);
            int k = abt[2 * p + 1] >= 97 && abt[2 * p + 1] <= 122 ? abt[2 * p + 1] - 97 + 10 : (abt[2 * p + 1] >= 65 && abt[2 * p + 1] <= 90 ? abt[2 * p + 1] - 65 + 10 : abt[2 * p + 1] - 48);
            int a = (j << 4) + k;
            bbt[p] = b = (byte)a;
        }
        return bbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProcessName() {
        BufferedReader mBufferedReader = null;
        try {
            File file = new File("/proc/" + Process.myPid() + "/cmdline");
            mBufferedReader = new BufferedReader(new FileReader(file));
            String string = mBufferedReader.readLine().trim();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (mBufferedReader != null) {
                try {
                    mBufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

