/*
 * Decompiled with CFR 0.152.
 */
package com.pax.eemv;

import com.pax.eemv.EmvImpl;
import com.pax.eemv.IEmvDeviceListener;
import com.pax.eemv.Utils;
import com.pax.eemv.entity.APDUResp;
import com.pax.eemv.entity.APDUSend;
import com.pax.eemv.entity.RSAPinKey;
import com.pax.eemv.exception.EEmvExceptions;

public class EmvDevice {
    private static IEmvDeviceListener listener;
    private static EmvDevice instance;
    private static EmvImpl paxEmvImpl;

    private EmvDevice() {
        this.jvmInit();
    }

    private native void jvmInit();

    public static EmvDevice getInstance(EmvImpl paxEmvImpl) {
        if (instance == null) {
            instance = new EmvDevice();
            EmvDevice.paxEmvImpl = paxEmvImpl;
        }
        return instance;
    }

    public void setEmvDeviceListener(IEmvDeviceListener listener) {
        EmvDevice.listener = listener;
    }

    public byte[] verifyPlainPin(int leftTimes) {
        int len = 4;
        int ret = EEmvExceptions.EMV_ERR_FUNCTION_NOT_IMPLEMENTED.getErrCodeFromBasement();
        byte[] iccResponse = new byte[2];
        byte[] retBytes = new byte[len];
        if (listener != null) {
            ret = listener.onVerifyPlainPin(leftTimes, iccResponse);
            retBytes = new byte[len += iccResponse.length];
            Utils.int2ByteArrayLittleEndian(ret, retBytes, 0);
            System.arraycopy(iccResponse, 0, retBytes, 4, iccResponse.length);
            return retBytes;
        }
        Utils.int2ByteArrayLittleEndian(ret, retBytes, 0);
        return retBytes;
    }

    public byte[] verifyCipherPin(RSAPinKey rsaPinKey, int leftTimes) {
        int len = 4;
        int ret = EEmvExceptions.EMV_ERR_FUNCTION_NOT_IMPLEMENTED.getErrCodeFromBasement();
        byte[] iccResponse = new byte[2];
        byte[] retBytes = new byte[len];
        if (listener != null) {
            ret = listener.onVerifyCipherPin(rsaPinKey, leftTimes, iccResponse);
            retBytes = new byte[len += iccResponse.length];
            Utils.int2ByteArrayLittleEndian(ret, retBytes, 0);
            System.arraycopy(iccResponse, 0, retBytes, 4, iccResponse.length);
            return retBytes;
        }
        Utils.int2ByteArrayLittleEndian(ret, retBytes, 0);
        return retBytes;
    }

    public int iccIsoCommand(int slot, APDUSend sApdu, APDUResp rApdu) {
        int ret = EEmvExceptions.EMV_ERR_FUNCTION_NOT_IMPLEMENTED.getErrCodeFromBasement();
        if (listener != null) {
            ret = listener.onDeivceIccIsoCommand(slot, sApdu, rApdu);
        }
        return ret;
    }

    public int piccIsoCommand(int slot, APDUSend sApdu, APDUResp rApdu) {
        int ret = EEmvExceptions.EMV_ERR_FUNCTION_NOT_IMPLEMENTED.getErrCodeFromBasement();
        if (listener != null) {
            ret = listener.onDeivcePiccIsoCommand(slot, sApdu, rApdu);
        }
        return ret;
    }
}

