/*
 * Decompiled with CFR 0.152.
 */
package com.pax.eemv;

import android.content.Context;
import com.pax.eemv.EmvContactless;
import com.pax.eemv.EmvDevice;
import com.pax.eemv.EmvTrans;
import com.pax.eemv.IEmv;
import com.pax.eemv.IEmvContactlessListener;
import com.pax.eemv.IEmvDeviceListener;
import com.pax.eemv.IEmvListener;
import com.pax.eemv.Log;
import com.pax.eemv.Utils;
import com.pax.eemv.entity.AidParam;
import com.pax.eemv.entity.Balance;
import com.pax.eemv.entity.Capk;
import com.pax.eemv.entity.Config;
import com.pax.eemv.entity.InputPBOCParam;
import com.pax.eemv.entity.InputParam;
import com.pax.eemv.entity.InputPayPassParam;
import com.pax.eemv.entity.InputPayWaveParam;
import com.pax.eemv.entity.ReaderParam;
import com.pax.eemv.enums.EACType;
import com.pax.eemv.enums.EChannelType;
import com.pax.eemv.enums.EKernelType;
import com.pax.eemv.enums.ELogType;
import com.pax.eemv.enums.EOnlineResult;
import com.pax.eemv.enums.ETransResult;
import com.pax.eemv.exception.EEmvExceptions;
import com.pax.eemv.exception.EmvException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class EmvImpl
implements IEmv {
    private static EmvImpl instance;
    private static Context context;
    private static EmvTrans paxEmvTrans;
    private static EmvDevice paxEmvDevice;
    private static EmvContactless paxEmvContactless;
    private static String appPath;
    private static List<Capk> capkList;
    private static List<AidParam> aidParamList;

    static {
        System.loadLibrary("SM_Android");
        System.loadLibrary("L2_Common");
        System.loadLibrary("L2_Conv");
        System.loadLibrary("emvCallback");
        System.loadLibrary("F_DEVICE_LIB_PayDroid");
        System.loadLibrary("F_PUBLIC_LIB_PayDroid");
        System.loadLibrary("F_EMV_LIB_PayDroid");
        System.loadLibrary("F_ENTRY_LIB_PayDroid");
        System.loadLibrary("F_WAVE_LIB_PayDroid");
        System.loadLibrary("F_MC_LIB_PayDroid");
        System.loadLibrary("F_QPBOC_LIB_PayDroid");
        System.loadLibrary("F_AE_LIB_PayDroid");
        System.loadLibrary("emvtrans");
        appPath = "";
        capkList = new ArrayList<Capk>();
        aidParamList = new ArrayList<AidParam>();
    }

    private EmvImpl() {
    }

    public static synchronized EmvImpl getInstance(Context context) {
        if (instance == null) {
            instance = new EmvImpl();
            try {
                instance.emvInit();
            }
            catch (EmvException emvException) {
                // empty catch block
            }
            appPath = String.valueOf(context.getFilesDir().getAbsoluteFile().getPath()) + File.separator;
        }
        EmvImpl.context = context;
        paxEmvTrans = EmvTrans.getInstance(instance);
        paxEmvDevice = EmvDevice.getInstance(instance);
        paxEmvContactless = EmvContactless.getInstance(instance);
        return instance;
    }

    @Override
    public IEmv getEmv() {
        return EmvImpl.getInstance(context);
    }

    @Override
    public native int emvInit() throws EmvException;

    protected native int nativeSetConfig(Config var1) throws EmvException;

    @Override
    public void setConfig(Config emvCfg) throws EmvException {
        int ret = this.nativeSetConfig(emvCfg);
        if (ret != EEmvExceptions.EMV_OK.getErrCodeFromBasement()) {
            EmvException e = new EmvException(ret);
            throw e;
        }
    }

    @Override
    public native Config getConfig() throws EmvException;

    protected native long getEcBalancePboc() throws EmvException;

    protected native byte[] getEcBalanceA(InputParam var1) throws EmvException;

    protected native byte[] readEcBalanceA(int var1) throws EmvException;

    protected native byte[] readLogRecordPboc(byte var1, int var2) throws EmvException;

    protected native Log readAllLogRecord(int var1, int var2) throws EmvException;

    @Override
    public native byte[] getTlv(int var1);

    protected native int nativeSetTlv(int var1, byte[] var2) throws EmvException;

    @Override
    public void setTlv(int tag, byte[] value) throws EmvException {
        int ret = this.nativeSetTlv(tag, value);
        if (ret != EEmvExceptions.EMV_OK.getErrCodeFromBasement()) {
            EmvException e = new EmvException(ret);
            throw e;
        }
    }

    protected native byte process(InputParam var1) throws EmvException;

    protected native int nativeBegin(InputParam var1) throws EmvException;

    @Override
    public int emvBegin(InputParam emvParam) throws EmvException {
        int ret = this.nativeBegin(emvParam);
        if (ret != EEmvExceptions.EMV_OK.getErrCodeFromBasement()) {
            EmvException e = new EmvException(ret);
            throw e;
        }
        return ret;
    }

    protected native byte nativeContinue() throws EmvException;

    @Override
    public EACType emvContinue() throws EmvException {
        byte ret = 0;
        ret = this.nativeContinue();
        return EACType.values()[ret];
    }

    protected native byte emvComplete(int var1) throws EmvException;

    @Override
    public ETransResult emvComplete(EOnlineResult onlineResult) throws EmvException {
        ETransResult transResult = null;
        byte ret = this.emvComplete(onlineResult.getOnlineResult());
        transResult = Utils.getEnum(ETransResult.class, ret - 1);
        if (transResult == null) {
            EmvException e = new EmvException(EEmvExceptions.EMV_ERR_UNKNOWN.getErrCodeFromBasement());
            throw e;
        }
        return transResult;
    }

    protected native int clssPreProc(InputParam var1) throws EmvException;

    @Override
    public void contactlessPreProc(InputParam emvParam) throws EmvException {
        int ret = this.clssPreProc(emvParam);
        if (ret != EEmvExceptions.EMV_OK.getErrCodeFromBasement()) {
            EmvException e = new EmvException(ret);
            throw e;
        }
    }

    protected native int clssBegin(byte[] var1) throws EmvException;

    @Override
    public ETransResult contactlessBegin() throws EmvException {
        byte[] tmpBytes = new byte[1];
        ETransResult transResult = null;
        int ret = this.clssBegin(tmpBytes);
        if (ret != EEmvExceptions.EMV_OK.getErrCodeFromBasement()) {
            EmvException e = new EmvException(ret);
            throw e;
        }
        transResult = Utils.getEnum(ETransResult.class, tmpBytes[0] - 1);
        if (transResult == null) {
            EmvException e = new EmvException(EEmvExceptions.EMV_ERR_UNKNOWN.getErrCodeFromBasement());
            throw e;
        }
        return transResult;
    }

    protected native int clssComplete(byte[] var1, int var2, byte[] var3, int var4) throws EmvException;

    @Override
    public void contactlessComplete(byte[] authData, byte[] script) throws EmvException {
        int ret = this.clssComplete(authData, authData.length, script, script.length);
        if (ret != EEmvExceptions.EMV_OK.getErrCodeFromBasement()) {
            EmvException e = new EmvException(ret);
            throw e;
        }
    }

    @Override
    public ETransResult emvProcess(InputParam emvParam) throws EmvException {
        byte ret = this.process(emvParam);
        if (ret <= 0) {
            EmvException e = new EmvException(ret);
            throw e;
        }
        ETransResult transResult = Utils.getEnum(ETransResult.class, ret - 1);
        if (transResult == null) {
            EmvException e = new EmvException(EEmvExceptions.EMV_ERR_UNKNOWN.getErrCodeFromBasement());
            throw e;
        }
        return transResult;
    }

    protected long getEcBalance(InputParam emvParam) throws EmvException {
        long lEcBalance = -1L;
        byte[] bEcBalance = this.getEcBalanceA(emvParam);
        if (bEcBalance != null) {
            lEcBalance = Long.parseLong(new String(bEcBalance));
        }
        return lEcBalance;
    }

    @Override
    public long readEcBalance(EChannelType channelType) throws EmvException {
        long lEcBalance = -1L;
        byte[] bEcBalance = this.readEcBalanceA(channelType.getChannelType());
        if (bEcBalance != null) {
            lEcBalance = Long.parseLong(new String(bEcBalance));
        }
        return lEcBalance;
    }

    @Override
    public List<byte[]> readAllLogRecord(EChannelType channelType, ELogType logType) throws EmvException {
        Log emvLog = this.readAllLogRecord(channelType.getChannelType(), logType.getLogType());
        byte[] logData = emvLog.getLogData();
        int cnt = emvLog.getCount();
        if (emvLog == null || logData == null || logData.length == 0 || cnt == 0) {
            return null;
        }
        if (logData.length % cnt != 0) {
            return null;
        }
        ArrayList<byte[]> emvLogList = new ArrayList<byte[]>();
        int itemLen = logData.length / cnt;
        int i = 0;
        while (i < cnt) {
            byte[] item = new byte[itemLen];
            System.arraycopy(logData, itemLen * i, item, 0, itemLen);
            emvLogList.add(item);
            ++i;
        }
        return emvLogList;
    }

    @Override
    public void setListener(IEmvListener listener) {
        paxEmvTrans.setEmvListener(listener);
    }

    @Override
    public void setAidParamList(List<AidParam> aidParamList) {
        EmvImpl.aidParamList = aidParamList == null ? new ArrayList<AidParam>() : aidParamList;
    }

    @Override
    public void setCapkList(List<Capk> capkList) {
        EmvImpl.capkList = capkList == null ? new ArrayList<Capk>() : capkList;
    }

    protected AidParam readAid(int index) {
        if (aidParamList.size() > index) {
            return aidParamList.get(index);
        }
        return null;
    }

    protected Capk readCapk(int index) {
        if (capkList.size() > index) {
            return capkList.get(index);
        }
        return null;
    }

    protected int getItemNum(boolean aidFlag) {
        if (aidFlag) {
            return aidParamList.size();
        }
        return capkList.size();
    }

    @Override
    public native byte[] getDataCommand(int var1) throws EmvException;

    @Override
    public void setDeviceListener(IEmvDeviceListener listener) {
        paxEmvDevice.setEmvDeviceListener(listener);
    }

    @Override
    public void setContactlessListener(IEmvContactlessListener listener) {
        paxEmvContactless.setEmvContactlessListener(listener);
    }

    @Override
    public native int contactlessParameterSetPBOC(InputPBOCParam var1);

    @Override
    public native int contactlessParameterSetWave(InputPayWaveParam var1);

    @Override
    public native int contactlessParameterSetPass(InputPayPassParam var1);

    private native ReaderParam getReaderParam(int var1) throws EmvException;

    @Override
    public ReaderParam getReaderParam(EKernelType kernelType) {
        try {
            return this.getReaderParam(kernelType.getKernelType());
        }
        catch (EmvException e) {
            e.printStackTrace();
            return null;
        }
    }

    private native int setReaderParam(int var1, ReaderParam var2) throws EmvException;

    @Override
    public int setReaderParam(EKernelType kernelType, ReaderParam readerParam) {
        try {
            return this.setReaderParam(kernelType.getKernelType(), readerParam);
        }
        catch (EmvException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private native byte[] getKernelTLV(int var1, int var2);

    @Override
    public byte[] getKernelTLV(EKernelType kernelType, int tag) {
        return this.getKernelTLV(kernelType.getKernelType(), tag);
    }

    private native int setKernelTLV(int var1, int var2, byte[] var3);

    @Override
    public int setKernelTLV(EKernelType kernelType, int tag, byte[] value) {
        return this.setKernelTLV(kernelType.getKernelType(), tag, value);
    }

    @Override
    public native String getVersion();

    private native byte[] readEcCurrencyBalance(int var1) throws EmvException;

    @Override
    public List<Balance> readEcCurrencyBalance(EChannelType channelType) throws EmvException {
        ArrayList<Balance> balanceList = new ArrayList<Balance>();
        byte[] bEcBalance = this.readEcCurrencyBalance(channelType.getChannelType());
        if (bEcBalance != null) {
            int num = bEcBalance[0];
            int i = 0;
            i = 0;
            while (i < num) {
                Balance balance = new Balance();
                byte[] currency = new byte[2];
                byte[] arrayByteBalance = new byte[12];
                System.arraycopy(bEcBalance, 1 + i * 14, currency, 0, 2);
                System.arraycopy(bEcBalance, 3 + i * 14, arrayByteBalance, 0, 12);
                balance.setCurrencyCode(currency);
                balance.setBalance(Long.parseLong(new String(arrayByteBalance)));
                balanceList.add(balance);
                ++i;
            }
        }
        return balanceList;
    }
}

