/*
 * Decompiled with CFR 0.152.
 */
package com.pax.eemv;

import com.pax.eemv.Amount;
import com.pax.eemv.EmvImpl;
import com.pax.eemv.IEmvListener;
import com.pax.eemv.Utils;
import com.pax.eemv.entity.Amounts;
import com.pax.eemv.entity.CandList;
import com.pax.eemv.enums.ECertType;
import com.pax.eemv.exception.EEmvExceptions;
import com.pax.eemv.exception.EmvException;
import java.util.ArrayList;

public class EmvTrans {
    private static IEmvListener listener;
    private static EmvTrans instance;
    private static EmvImpl paxEmvImpl;

    private EmvTrans() {
        this.jvmInit();
    }

    public static EmvTrans getInstance(EmvImpl paxEmvImpl) {
        if (instance == null) {
            instance = new EmvTrans();
            EmvTrans.paxEmvImpl = paxEmvImpl;
        }
        return instance;
    }

    public void setEmvListener(IEmvListener listener) {
        EmvTrans.listener = listener;
    }

    private native void jvmInit();

    public Amount getAmount() {
        Amount amt = new Amount();
        if (listener != null) {
            Amounts emvAmounts = listener.onGetAmounts();
            try {
                amt.setAmount(emvAmounts.getTransAmount());
                amt.setCashBackAmt(emvAmounts.getCashBackAmount());
            }
            catch (EmvException emvException) {
                // empty catch block
            }
        }
        return amt;
    }

    public int waitAppSelect(int tryCnt, CandList[] appList, int appNum) {
        int i = 0;
        while (i < appList.length) {
            ++i;
        }
        if (listener != null) {
            ArrayList<CandList> candLists = new ArrayList<CandList>();
            CandList[] candListArray = appList;
            int n = appList.length;
            int n2 = 0;
            while (n2 < n) {
                CandList candList = candListArray[n2];
                candLists.add(candList);
                ++n2;
            }
            return listener.onWaitAppSelect(tryCnt < 1, candLists);
        }
        return EEmvExceptions.EMV_ERR_LISTENER_IS_NULL.getErrCodeFromBasement();
    }

    public int setParam(byte onlinePin, byte[] aid) {
        if (listener != null) {
            return listener.onSetParam(onlinePin, aid);
        }
        return EEmvExceptions.EMV_ERR_LISTENER_IS_NULL.getErrCodeFromBasement();
    }

    public int confirmCardNo(String pan) {
        if (listener != null) {
            return listener.onConfirmCardNo(pan);
        }
        return EEmvExceptions.EMV_ERR_LISTENER_IS_NULL.getErrCodeFromBasement();
    }

    public int certVerify() {
        byte[] tag_9f61 = paxEmvImpl.getTlv(40801);
        if (tag_9f61 != null && tag_9f61.length > 0) {
            if (tag_9f61.length > 40) {
                return EEmvExceptions.EMV_ERR_TAG_LENGTH.getErrCodeFromBasement();
            }
            byte[] tag_9f62 = paxEmvImpl.getTlv(40802);
            if (tag_9f62 == null) {
                return EEmvExceptions.EMV_ERR_PARAM.getErrCodeFromBasement();
            }
            if (tag_9f62[0] > ECertType.OTHER_CREDENTIAL.getCertType()) {
                tag_9f62[0] = ECertType.OTHER_CREDENTIAL.getCertType();
            }
            if (listener != null) {
                return listener.onCertVerify(Utils.getEnum(ECertType.class, tag_9f62[0]), new String(tag_9f61));
            }
            return EEmvExceptions.EMV_ERR_LISTENER_IS_NULL.getErrCodeFromBasement();
        }
        return EEmvExceptions.EMV_ERR_PARAM.getErrCodeFromBasement();
    }

    public int cardHolderPwd(boolean bOnlinePin, int leftTimes, byte[] pinData) {
        if (listener != null) {
            return listener.onCardHolderPwd(bOnlinePin, leftTimes, pinData);
        }
        return EEmvExceptions.EMV_ERR_LISTENER_IS_NULL.getErrCodeFromBasement();
    }

    public int onlineProc() {
        if (listener != null) {
            return listener.onOnlineProc().getOnlineResult();
        }
        return EEmvExceptions.EMV_ERR_LISTENER_IS_NULL.getErrCodeFromBasement();
    }

    public void clssRemoveCardPrompt() {
        if (listener != null) {
            listener.onRemoveCardPrompt();
        }
    }

    public boolean chkExceptionFile() {
        if (listener != null) {
            return listener.onChkExceptionFile();
        }
        return false;
    }

    public int detectRFCardAgain() {
        if (listener != null) {
            return listener.onDetectRFCardAgain();
        }
        return EEmvExceptions.EMV_ERR_LISTENER_IS_NULL.getErrCodeFromBasement();
    }

    public boolean requestEcashTips() {
        if (listener != null) {
            return listener.onConfirmECTips();
        }
        return false;
    }

    public int getTagListVal(byte[] tagvals, int ilen) {
        if (listener != null) {
            return listener.onGetTagsVal(tagvals, ilen);
        }
        return EEmvExceptions.EMV_ERR_LISTENER_IS_NULL.getErrCodeFromBasement();
    }

    public void displayMsg(int iMsgId) {
    }
}

