/*
 * Decompiled with CFR 0.152.
 */
package com.pax.eemv;

import java.io.UnsupportedEncodingException;
import java.util.zip.CRC32;

public class Utils {
    protected static String bcd2Str(byte[] b) {
        if (b == null) {
            return null;
        }
        char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder sb = new StringBuilder(b.length * 2);
        int i = 0;
        while (i < b.length) {
            sb.append(HEX_DIGITS[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_DIGITS[b[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    protected static byte[] str2Bcd(String asc) {
        int len = asc.length();
        int mod = len % 2;
        if (mod != 0) {
            asc = "0" + asc;
            len = asc.length();
        }
        byte[] abt = new byte[len];
        if (len >= 2) {
            len /= 2;
        }
        byte[] bbt = new byte[len];
        abt = asc.getBytes();
        int p = 0;
        while (p < asc.length() / 2) {
            byte b;
            int j = abt[2 * p] >= 97 && abt[2 * p] <= 122 ? abt[2 * p] - 97 + 10 : (abt[2 * p] >= 65 && abt[2 * p] <= 90 ? abt[2 * p] - 65 + 10 : abt[2 * p] - 48);
            int k = abt[2 * p + 1] >= 97 && abt[2 * p + 1] <= 122 ? abt[2 * p + 1] - 97 + 10 : (abt[2 * p + 1] >= 65 && abt[2 * p + 1] <= 90 ? abt[2 * p + 1] - 65 + 10 : abt[2 * p + 1] - 48);
            int a = (j << 4) + k;
            bbt[p] = b = (byte)a;
            ++p;
        }
        return bbt;
    }

    protected static void int2ByteArray(int i, byte[] to, int offset) {
        to[offset] = (byte)(i >>> 24 & 0xFF);
        to[offset + 1] = (byte)(i >>> 16 & 0xFF);
        to[offset + 2] = (byte)(i >>> 8 & 0xFF);
        to[offset + 3] = (byte)(i & 0xFF);
    }

    protected static void int2ByteArrayLittleEndian(int i, byte[] to, int offset) {
        to[offset] = (byte)(i & 0xFF);
        to[offset + 1] = (byte)(i >>> 8 & 0xFF);
        to[offset + 2] = (byte)(i >>> 16 & 0xFF);
        to[offset + 3] = (byte)(i >>> 24 & 0xFF);
    }

    protected static void short2ByteArray(short s, byte[] to, int offset) {
        to[offset] = (byte)(s >>> 8 & 0xFF);
        to[offset + 1] = (byte)(s & 0xFF);
    }

    protected static void short2ByteArrayLittleEndian(short s, byte[] to, int offset) {
        to[offset] = (byte)(s & 0xFF);
        to[offset + 1] = (byte)(s >>> 8 & 0xFF);
    }

    protected static int byteArray2Int(byte[] from, int offset) {
        return from[offset] << 24 & 0xFF000000 | from[offset + 1] << 16 & 0xFF0000 | from[offset + 2] << 8 & 0xFF00 | from[offset + 3] & 0xFF;
    }

    protected static int byteArray2IntLittleEndian(byte[] from, int offset) {
        return from[offset + 3] << 24 & 0xFF000000 | from[offset + 2] << 16 & 0xFF0000 | from[offset + 1] << 8 & 0xFF00 | from[offset] & 0xFF;
    }

    protected static short byteArray2Short(byte[] from, int offset) {
        return (short)(from[offset] << 8 & 0xFF00 | from[offset + 1] & 0xFF);
    }

    protected static short byteArray2ShortLittleEndian(byte[] from, int offset) {
        return (short)(from[offset + 1] << 8 & 0xFF00 | from[offset] & 0xFF);
    }

    protected static long getCRC32(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data);
        return crc.getValue();
    }

    protected static int bytes2Int(byte[] buffer, int radix) {
        int result = 0;
        try {
            result = Integer.valueOf(Utils.bytes2String(buffer), radix);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected static String bytes2String(byte[] source) {
        String result = "";
        try {
            if (source.length > 0) {
                result = new String(source, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected static int bytes2Int(byte[] buffer) {
        int result = 0;
        int len = buffer.length;
        if (len <= 0 || len > 4) {
            return 0;
        }
        int i = 0;
        while (i < len) {
            result += Utils.byte2Int(buffer[i]) << 8 * i;
            ++i;
        }
        return result;
    }

    protected static int byte2Int(byte b) {
        return b & 0xFF;
    }

    public static <T extends Enum<T>> T getEnum(Class<T> clazz, int ordinal) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum t = enumArray[n2];
            if (t.ordinal() == ordinal) {
                return (T)t;
            }
            ++n2;
        }
        return null;
    }
}

