/*
 * Decompiled with CFR 0.152.
 */
package com.pax.eemv.exception;

import com.pax.eemv.exception.AGeneralException;
import com.pax.eemv.exception.EEmvExceptions;

public class EmvException
extends AGeneralException {
    private static final long serialVersionUID = 1L;
    private static final String MODULE = "EMV";

    public EmvException(String errCode) {
        this(Integer.parseInt(errCode));
    }

    public EmvException(int errCode) {
        this(EEmvExceptions.values()[EmvException.getErrIndex(errCode)]);
    }

    public EmvException(EEmvExceptions errCode) {
        super(MODULE, EmvException.getErrIndex(errCode), errCode.getErrMsg());
    }

    public EmvException(EEmvExceptions errCode, String extraInfo, Throwable throwable) {
        super(MODULE, EmvException.getErrIndex(errCode), errCode.getErrMsg(), extraInfo, throwable);
    }

    public EmvException(EEmvExceptions errCode, String extraInfo) {
        super(MODULE, EmvException.getErrIndex(errCode), errCode.getErrMsg(), extraInfo);
    }

    public EmvException(EEmvExceptions errCode, Throwable throwable) {
        super(MODULE, EmvException.getErrIndex(errCode), errCode.getErrMsg(), throwable);
    }

    private static int getErrIndex(EEmvExceptions errCode) {
        EEmvExceptions[] eEmvExceptionsArray = EEmvExceptions.values();
        int n = eEmvExceptionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EEmvExceptions e = eEmvExceptionsArray[n2];
            if (e.equals((Object)errCode)) {
                return errCode.getErrCodeFromBasement();
            }
            ++n2;
        }
        return EEmvExceptions.EMV_ERR_UNKNOWN.getErrCodeFromBasement();
    }

    private static int getErrIndex(int errCode) {
        int result = 0;
        EEmvExceptions[] eEmvExceptionsArray = EEmvExceptions.values();
        int n = eEmvExceptionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EEmvExceptions e = eEmvExceptionsArray[n2];
            if (e.getErrCodeFromBasement() == errCode) {
                return result;
            }
            ++result;
            ++n2;
        }
        return EEmvExceptions.EMV_ERR_UNKNOWN.ordinal();
    }
}

