/*
 * Decompiled with CFR 0.152.
 */
package com.pax.gl;

import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AppLog {
    public static String getDebugInfo(Exception serializable) {
        serializable = ((Throwable)serializable).getStackTrace()[1];
        return String.valueOf(((StackTraceElement)serializable).getFileName()) + "_" + ((StackTraceElement)serializable).getMethodName() + "_" + ((StackTraceElement)serializable).getLineNumber();
    }

    public static String buildTag(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IPP_").append(AppLog.getDebugInfo(exception));
        return stringBuffer.toString();
    }

    public static String buildTag(ELogModule eLogModule) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IPP_").append(eLogModule.name());
        return stringBuffer.toString();
    }

    public static String buildTag(ELogModule eLogModule, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IPP_").append(eLogModule.name()).append("_").append(string2);
        return stringBuffer.toString();
    }

    public static String buildMsg(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new SimpleDateFormat("MM-dd HH:mm:ss.SSS").format(new Date())).append(" ").append(string2);
        return stringBuffer.toString();
    }

    public static void gld(String string2, String string3) {
        AppLog.d(ELogModule.GL, string2, string3);
    }

    public static void glw(String string2, String string3) {
        AppLog.w(ELogModule.GL, string2, string3);
    }

    public static void gle(String string2, String string3) {
        AppLog.e(ELogModule.GL, string2, string3);
    }

    public static void dald(String string2, String string3) {
        AppLog.d(ELogModule.DAL, string2, string3);
    }

    public static void dalw(String string2, String string3) {
        AppLog.w(ELogModule.DAL, string2, string3);
    }

    public static void dale(String string2, String string3) {
        AppLog.e(ELogModule.DAL, string2, string3);
    }

    public static void d(ELogModule eLogModule, String string2, String string3) {
        Log.d((String)AppLog.buildTag(eLogModule, string2), (String)AppLog.buildMsg(string3));
    }

    public static void w(ELogModule eLogModule, String string2, String string3) {
        Log.w((String)AppLog.buildTag(eLogModule, string2), (String)AppLog.buildMsg(string3));
    }

    public static void e(ELogModule eLogModule, String string2, String string3) {
        Log.e((String)AppLog.buildTag(eLogModule, string2), (String)AppLog.buildMsg(string3));
    }

    public static void e(Exception exception) {
        Log.e((String)("IPP_" + AppLog.getDebugInfo(exception)), (String)AppLog.buildMsg(exception.getMessage()));
    }

    public static enum ELogModule {
        GL,
        DAL,
        EMV,
        IPPI,
        IPPS,
        IPPSI;

    }
}

