/*
 * Decompiled with CFR 0.152.
 */
package com.pax.gl.algo;

import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public interface IAlgo {
    public byte[] xor(byte[] var1, byte[] var2, int var3);

    public void randomBytes(byte[] var1);

    public String md5(byte[] var1);

    public String sha1(byte[] var1);

    public String sha256(byte[] var1);

    public byte[] des(ECryptOperation var1, ECryptOption var2, ECryptPaddingOption var3, byte[] var4, byte[] var5, byte[] var6);

    public byte[] aes(ECryptOperation var1, ECryptOption var2, ECryptPaddingOption var3, byte[] var4, byte[] var5, byte[] var6);

    public String base64Encode(byte[] var1);

    public byte[] base64Decode(String var1);

    public Short crc16ccitt(byte[] var1);

    public Integer crc32(byte[] var1);

    public String integerStrAdd(String var1, String var2);

    public IRsa getRsa();

    public boolean setBit(byte[] var1, int var2, byte var3);

    public Byte getBit(byte[] var1, int var2);

    public static enum ECryptOperation {
        ENCRYPT,
        DECRYPT;

    }

    public static enum ECryptOption {
        CBC,
        ECB;

    }

    public static enum ECryptPaddingOption {
        NO_PADDING,
        PCKS5_PADDING;

    }

    public static interface IRsa {
        public KeyPair genKeyPair(int var1);

        public RSAPublicKey genPublicKey(byte[] var1, byte[] var2);

        public RSAPrivateKey genPrivateKey(byte[] var1, byte[] var2);

        public byte[] encryptWithPublicKey(RSAPublicKey var1, byte[] var2, PaddingOption var3);

        public byte[] encryptWithPrivateKey(RSAPrivateKey var1, byte[] var2, PaddingOption var3);

        public byte[] decryptWithPrivateKey(RSAPrivateKey var1, byte[] var2, PaddingOption var3);

        public byte[] decryptWithPublicKey(RSAPublicKey var1, byte[] var2, PaddingOption var3);

        public byte[] sign(byte[] var1, RSAPrivateKey var2, SignAlgorithm var3);

        public boolean verifySign(byte[] var1, RSAPublicKey var2, byte[] var3, SignAlgorithm var4);

        public static enum PaddingOption {
            NO_PADDING,
            PKCS1_PADDING;

        }

        public static enum SignAlgorithm {
            MD5_WITH_RSA,
            SHA1_WITH_RSA,
            SHA256_WITH_RSA;

        }
    }
}

