/*
 * Decompiled with CFR 0.152.
 */
package com.pax.gl.db;

import com.pax.gl.db.DbException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import net.sqlcipher.database.SQLiteDatabase;

public interface IDb {
    public <T extends AEntityBase> IDao<T> getDb(int var1, String var2, String var3, Class<T> var4, IDbListener<T> var5) throws DbException;

    public <T extends AEntityBase> IDao<T> getDb(int var1, String var2, String var3, Class<T> var4, String var5, IDbListener<T> var6) throws DbException;

    public <T extends AEntityBase> IDao<T> getDb(int var1, String var2, String var3, String var4, Class<T> var5, String var6, IDbListener<T> var7) throws DbException;

    public static abstract class AEntityBase {
        @Id
        @GeneratedValue
        private Integer id;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer n2) throws DbException {
            if (n2 <= 0) {
                throw new DbException(1301);
            }
            this.id = n2;
        }

        public void clearId() {
            this.id = null;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Column {
        public boolean canBeNull() default false;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface GeneratedValue {
    }

    public static interface IDao<T extends AEntityBase> {
        public SQLiteDatabase getDb();

        public void save(T var1) throws DbException;

        public void save(List<T> var1) throws DbException;

        public void delete(int var1) throws DbException;

        public void delete(int[] var1) throws DbException;

        public void deleteAll() throws DbException;

        public void update(T var1) throws DbException;

        public void updateByCondition(String var1, T var2) throws DbException;

        public T find(int var1) throws DbException;

        public T findLast() throws DbException;

        public List<T> findByCondition(String var1) throws DbException;

        public List<T> findAll() throws DbException;

        public long getCount() throws DbException;

        public void dropTable() throws DbException;

        public void dropAllTable() throws DbException;

        public void switchToTable(String var1) throws DbException;

        public void beginTransaction();

        public void endTransaction() throws DbException;
    }

    public static interface IDbListener<T extends AEntityBase> {
        public IDao<T> onUpdate(IDao<T> var1, int var2, int var3);
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Id {
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Unique {
    }
}

