/*
 * Decompiled with CFR 0.152.
 */
package com.pax.gl.lbs;

import java.util.Date;
import java.util.List;

public interface ILbs {
    public LocationInfoTerminal getLocationInfoTerminal();

    public List<LocationInfoCell> getLocationInfoCellList();

    public void clearLocationInfoCellList();

    public LocationInfoOperator getLocationInfoOperator();

    public void startLocate(ILocationListener var1);

    public void startLocate(int var1, ILocationListener var2);

    public void stopLocate();

    public boolean isGpsEnabled();

    public static enum ELocationType {
        LOCATION_BY_TERMINAL,
        LOCATION_BY_BASE_STATION,
        LOCATION_BY_OPERATOR;

    }

    public static enum ENetType {
        NET_CDMA,
        NET_GSM;

    }

    public static interface ILocationListener {
        public void onLocated(LocationInfo var1);
    }

    public static abstract class LocationInfo {
        private long timeMillis;

        public abstract ELocationType getType();

        public long getTimeMillis() {
            return this.timeMillis;
        }

        public void setTimeMillis(long l2) {
            this.timeMillis = l2;
        }

        public abstract String toString();
    }

    public static class LocationInfoCell
    extends LocationInfo {
        private ENetType netType;
        private String mcc;
        private String mnc;
        private int lac;
        private int cid;
        private int sid;
        private int nid;
        private int bid;
        private int signal;

        public LocationInfoCell(ENetType eNetType) {
            this.netType = eNetType;
        }

        public ENetType getNetType() {
            return this.netType;
        }

        public String getMcc() {
            return this.mcc;
        }

        public void setMcc(String string2) {
            this.mcc = string2;
        }

        public String getMnc() {
            return this.mnc;
        }

        public void setMnc(String string2) {
            this.mnc = string2;
        }

        public int getSid() {
            return this.sid;
        }

        public void setSid(int n2) {
            this.sid = n2;
        }

        public int getNid() {
            return this.nid;
        }

        public void setNid(int n2) {
            this.nid = n2;
        }

        public int getBid() {
            return this.bid;
        }

        public void setBid(int n2) {
            this.bid = n2;
        }

        public int getLac() {
            return this.lac;
        }

        public void setLac(int n2) {
            this.lac = n2;
        }

        public int getCid() {
            return this.cid;
        }

        public void setCid(int n2) {
            this.cid = n2;
        }

        public int getSignal() {
            return this.signal;
        }

        public void setSignal(int n2) {
            this.signal = n2;
        }

        @Override
        public ELocationType getType() {
            return ELocationType.LOCATION_BY_BASE_STATION;
        }

        @Override
        public String toString() {
            return String.format("LocationInfoCell nettype: " + (Object)((Object)this.netType) + " mcc:" + this.mcc + " mnc: " + this.mnc + " lac: " + this.lac + " cid: " + this.cid + " sid: " + this.sid + " nid:" + this.nid + " bid: " + this.bid + " signal: " + this.signal + " time: " + new Date(this.getTimeMillis()), new Object[0]);
        }
    }

    public static class LocationInfoOperator
    extends LocationInfo {
        private String imsi;

        public String getImsi() {
            return this.imsi;
        }

        public void setImsi(String string2) {
            this.imsi = string2;
        }

        @Override
        public ELocationType getType() {
            return ELocationType.LOCATION_BY_OPERATOR;
        }

        @Override
        public String toString() {
            return String.format("LocationInfoOperator imsi: " + this.imsi + "time: " + new Date(this.getTimeMillis()), new Object[0]);
        }
    }

    public static class LocationInfoTerminal
    extends LocationInfo {
        private String longitude;
        private String latitude;

        public String getLongitude() {
            return this.longitude;
        }

        public void setLongitude(String string2) {
            this.longitude = string2;
        }

        public String getLatitude() {
            return this.latitude;
        }

        public void setLatitude(String string2) {
            this.latitude = string2;
        }

        @Override
        public ELocationType getType() {
            return ELocationType.LOCATION_BY_TERMINAL;
        }

        @Override
        public String toString() {
            return String.format("LocationInfoTerminal: (" + this.longitude + ", " + this.latitude + "), time: " + new Date(this.getTimeMillis()), new Object[0]);
        }
    }
}

