/*
 * Decompiled with CFR 0.152.
 */
package com.pax.serial.api;

import android.os.SystemClock;
import android.util.Log;
import android_serialport_api.SerialPortPax;
import com.pax.serial.api.SerialPortException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialPort {
    private String eG;
    private String aW;
    private int eH;
    private int eI;
    private int eJ;
    private int eK;
    private SerialPortPax eL;
    private OutputStream eM;
    private InputStream eN;
    private int i;
    private int eO;
    private boolean bG = false;
    private boolean D = false;

    public SerialPort(String string2, String string3) {
        this.eG = string2;
        this.aW = string3;
        this.eH = 115200;
        this.eI = 8;
        this.eJ = 78;
        this.eK = 1;
        this.i = 5000;
        this.eO = 10000;
        this.D = false;
    }

    public void connect() throws SerialPortException {
        Log.d((String)"CommUart", (String)">>>connect");
        String[] stringArray = this.aW;
        SerialPort serialPort = this;
        stringArray = stringArray.split(",");
        if (stringArray.length == 4) {
            serialPort.eH = Integer.parseInt(stringArray[0].trim());
            serialPort.eI = Integer.parseInt(stringArray[1].trim());
            serialPort.eJ = stringArray[2].trim().charAt(0);
            serialPort.eK = Integer.parseInt(stringArray[3].trim());
        }
        try {
            this.eL = new SerialPortPax(new File(this.eG), this.eH, this.eI, this.eJ, this.eK, 0);
            Log.d((String)"CommUart", (String)("open serial port:" + this.eG + " success"));
            this.eM = this.eL.getOutputStream();
            this.eN = this.eL.getInputStream();
            this.D = true;
            Log.d((String)"CommUart", (String)">>>connect success");
            return;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            Log.e((String)"CommUart", (String)"connect error - SecurityException");
            throw new SerialPortException(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Log.e((String)"CommUart", (String)"connect error - IOException");
            throw new SerialPortException(1);
        }
    }

    public void disconnect() {
        Log.d((String)"CommUart", (String)">>>disconnect");
        this.D = false;
        this.bG = false;
        if (this.eL != null) {
            this.eL.close();
        }
        this.eL = null;
        if (this.eM != null) {
            try {
                this.eM.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.eM = null;
        if (this.eN != null) {
            try {
                this.eN.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.eN = null;
        Log.d((String)"CommUart", (String)"DeviceCon close\n");
    }

    public void send(byte[] byArray) throws SerialPortException {
        Log.d((String)"CommUart", (String)">>>send");
        if (this.eM == null) {
            Log.e((String)"CommUart", (String)"send error - mOutputStream == null, may connect firstly");
            throw new SerialPortException(2);
        }
        try {
            this.eM.write(byArray);
            Log.d((String)"CommUart", (String)"send success");
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new SerialPortException(2);
        }
    }

    public byte[] recv(int n2) throws SerialPortException {
        int n3;
        Log.d((String)"CommUart", (String)">>>recv");
        if (this.eN == null) {
            Log.e((String)"CommUart", (String)"recv error - mInputStream == null, may connect firstly");
            throw new SerialPortException(2);
        }
        byte[] byArray = new byte[n2];
        this.bG = true;
        long l2 = System.currentTimeMillis() + (long)this.eO;
        for (n3 = 0; this.bG && n3 < n2 && System.currentTimeMillis() < l2; n3 += this.eN.read(byArray, n3, n2 - n3)) {
            try {
                if (this.eN == null) break;
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Log.e((String)"CommUart", (String)"mInputStream.read IOException");
                break;
            }
        }
        this.bG = false;
        if (n3 == n2) {
            return byArray;
        }
        if (n3 > 0 && n3 < n2) {
            Log.w((String)"CommUart", (String)"recv not enough data");
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        if (n3 == 0) {
            Log.w((String)"CommUart", (String)"recv nothing");
            return new byte[0];
        }
        return new byte[0];
    }

    public boolean isConnected() {
        return this.D;
    }

    public int getConnectTimeout() {
        return this.i;
    }

    public int getTransTimeout() {
        return this.eO;
    }

    public void cancelRecv() {
        this.bG = false;
    }

    public void reset() {
        Log.d((String)"CommUart", (String)">>>reset");
        this.bG = false;
        int n2 = 0;
        if (this.eN != null) {
            try {
                n2 = this.eN.available();
                if (n2 == 0) {
                    Log.d((String)"CommUart", (String)"reset - nothing to do");
                    return;
                }
                this.eN.skip(n2);
                SystemClock.sleep((long)500L);
                this.eN.skip(this.eN.available());
                return;
            }
            catch (IOException iOException) {
                Object var1_2 = null;
                iOException.printStackTrace();
                return;
            }
        }
    }

    public void setConnectTimeout(int n2) {
        this.i = n2;
    }

    public void setTransTimeout(int n2) {
        this.eO = n2;
    }

    public byte[] recvNonBlocking() throws SerialPortException {
        Log.d((String)"CommUart", (String)">>>recvNonBlocking");
        if (this.eN == null) {
            Log.e((String)"CommUart", (String)"recv error - mInputStream == null, may connect firstly");
            throw new SerialPortException(2);
        }
        try {
            int n2 = this.eN.available();
            if (n2 <= 0) {
                return new byte[0];
            }
            byte[] byArray = new byte[n2];
            Log.d((String)"CommUart", (String)("has data, data len : " + n2));
            int n3 = this.eN.read(byArray, 0, n2);
            if (n3 == n2) {
                return byArray;
            }
            if (n3 > 0 && n3 < n2) {
                Log.w((String)"CommUart", (String)"retLen != availableLen");
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                return byArray2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Log.e((String)"CommUart", (String)"mInputStream.read IOException");
        }
        return new byte[0];
    }
}

