/*
 * Decompiled with CFR 0.152.
 */
package com.pax.cocoa.tools;

import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class Convert {
    public static byte[] intToBytes(long num) {
        byte[] tmp = new byte[4];
        int i = 0;
        while (i < 4) {
            tmp[i] = (byte)(num >>> 24 - i * 8);
            ++i;
        }
        return tmp;
    }

    public static long bytesToLong(byte[] bytes, boolean bytesIsHex, int radix) {
        long result = 0L;
        try {
            result = bytesIsHex ? Long.parseLong(Convert.hexBytesToStr(bytes), radix) : Long.parseLong(Convert.bcdBytesToStr(bytes), radix);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static int bytesToInt(byte[] bytes, boolean bytesIsHex, int radix) {
        return (int)Convert.bytesToLong(bytes, bytesIsHex, radix);
    }

    public static String hexBytesToStr(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String bytesToHexStr(byte[] byteArr) {
        if (byteArr == null || byteArr.length == 0) {
            return "";
        }
        StringBuffer strBufTemp = new StringBuffer("");
        int i = 0;
        while (i < byteArr.length) {
            String stmp = Integer.toHexString(byteArr[i] & 0xFF);
            if (stmp.length() == 1) {
                strBufTemp.append("0" + stmp);
            } else {
                strBufTemp.append(stmp);
            }
            ++i;
        }
        return strBufTemp.toString().toUpperCase(Locale.getDefault());
    }

    public static byte[] strToHexBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return new byte[0];
        }
        String hexData = hexString.toUpperCase(Locale.getDefault()).replaceAll(" ", "");
        int length = hexData.length() / 2;
        char[] hexChars = hexData.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(Convert.charToByte(hexChars[pos]) << 4 | Convert.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    public static String bcdBytesToStr(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        char[] c = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        int i = 0;
        while (i < bytes.length) {
            sb.append(c[(bytes[i] & 0xF0) >>> 4]).append(c[bytes[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    public static String bcdByteToStr(byte b) {
        char[] c = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder sb = new StringBuilder(2);
        sb.append(c[(b & 0xF0) >>> 4]).append(c[b & 0xF]);
        return sb.toString();
    }

    public static byte[] strToBcdBytes(String str, boolean isPaddingLeft) {
        if (str == null) {
            return new byte[0];
        }
        int mod = (str = str.toUpperCase()).length() % 2;
        if (mod != 0) {
            str = !isPaddingLeft ? String.valueOf(str) + "0" : "0" + str;
        }
        int len = str.length() / 2;
        byte[] result = new byte[len];
        char[] achar = str.toCharArray();
        int i = 0;
        while (i < len) {
            int pos = i * 2;
            result[i] = (byte)(Convert.charToByte(achar[pos]) << 4 | Convert.charToByte(achar[pos + 1]));
            ++i;
        }
        return result;
    }

    private static byte charToByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    public static int getLastIndexOf(byte value, byte[] items) {
        int i = items.length;
        while (--i >= 0) {
            if (items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int byteArray2Int(byte[] from, int offset) {
        return from[offset] << 24 & 0xFF000000 | from[offset + 1] << 16 & 0xFF0000 | from[offset + 2] << 8 & 0xFF00 | from[offset + 3] & 0xFF;
    }

    public static String filterInput(byte[] source) {
        String result = "";
        try {
            result = new String(source, "GBK").replaceAll("[^(a-zA-Z0-9\\u4e00-\\u9fa5 )]", "");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }
}

