/*
 * Decompiled with CFR 0.152.
 */
package com.pax.cocoa.tools;

import android.annotation.SuppressLint;
import android.util.Log;
import com.pax.cocoa.tools.Bytes;
import com.pax.cocoa.tools.Convert;
import com.pax.cocoa.tools.entity.TlvCell;
import java.util.HashMap;
import java.util.Map;

public class Tlv {
    private static String TAG = "CocoaBean.tools";

    public static byte[] pack(Map<Integer, TlvCell> tlvCellList) {
        byte[] result = new byte[]{};
        if (tlvCellList == null) {
            return result;
        }
        for (Integer key : tlvCellList.keySet()) {
            TlvCell tlvCell = tlvCellList.get(key);
            byte[] cell = Tlv.mergeTlv(tlvCell.getTag(), tlvCell.getValue());
            result = Bytes.mergeBytes(result, cell);
        }
        return result;
    }

    @SuppressLint(value={"UseSparseArrays"})
    public static Map<Integer, TlvCell> unpack(byte[] data) {
        HashMap<Integer, TlvCell> tlvCellList = new HashMap<Integer, TlvCell>();
        int offset = 0;
        while (offset < data.length) {
            int[] len;
            TlvCell tlvCell = new TlvCell();
            tlvCell.setTag(Tlv.getTagFromPackage(data, offset));
            if ((offset += tlvCell.getTag().length) > data.length) {
                Log.e((String)TAG, (String)"input data error");
                break;
            }
            if ((offset += (len = Tlv.getLengthFromPackage(data, offset))[0]) + len[1] > data.length) {
                Log.e((String)TAG, (String)"input data error");
                break;
            }
            tlvCell.setValue(Bytes.memcpy(data, offset, len[1]));
            offset += len[1];
            tlvCellList.put(Convert.bytesToInt(tlvCell.getTag(), false, 16), tlvCell);
        }
        return tlvCellList;
    }

    private static byte[] mergeTlv(byte[] tag, byte[] value) {
        byte[] len = Tlv.getTlvValueLen(value.length);
        byte[] array = new byte[tag.length + len.length + value.length];
        System.arraycopy(tag, 0, array, 0, tag.length);
        System.arraycopy(len, 0, array, tag.length, len.length);
        System.arraycopy(value, 0, array, tag.length + len.length, value.length);
        return array;
    }

    private static byte[] getTlvValueLen(int valueLength) {
        int offset = 0;
        byte[] lengthTmp = Convert.intToBytes(valueLength);
        int i = 0;
        while (i < lengthTmp.length) {
            if (lengthTmp[i] == 0) {
                ++offset;
            }
            ++i;
        }
        byte[] result = new byte[lengthTmp.length - offset];
        System.arraycopy(lengthTmp, offset, result, 0, lengthTmp.length - offset);
        return result;
    }

    private static byte[] getTagFromPackage(byte[] data, int offset) {
        int len = 0;
        if (data[offset] == 0) {
            return new byte[0];
        }
        len = (data[offset] & 0x1F) == 31 ? ((data[offset + 1] & 0x80) == 128 ? 3 : 2) : 1;
        byte[] result = new byte[len];
        System.arraycopy(data, offset, result, 0, len);
        return result;
    }

    private static int[] getLengthFromPackage(byte[] data, int offset) {
        int[] result = new int[2];
        if ((data[offset] & 0x80) == 0) {
            result[0] = 1;
            result[1] = data[offset];
        } else {
            int length = data[offset] & 0x7F;
            ++offset;
            int len = 0;
            int i = 0;
            while (i < length) {
                len <<= 8;
                len += data[offset] & 0xFF;
                ++i;
                ++offset;
            }
            result[0] = length + 1;
            result[1] = len;
        }
        return result;
    }
}

